
# primePeriods.py
'''
  list the length of the repeating decimal for
  all the reciprocals of primes up to 3000

  Put a * for those repeats which have maximal
  period/length of p-1
'''

from prime import *
from repFrac import *

ps = primes(3000)
i = 0
for p in ps:
  seq = findRepSeq(1, p)  # find seq for 1/p
  if seq == None:
    print(f"{p:4d}:{0:<4d}  ", end = '')
  else:
    if len(seq) == p-1:
      print(f"{p:4d}:{len(seq):<4d}* ", end = '')
    else:
      print(f"{p:4d}:{len(seq):<4d}  ", end = '')
  i += 1
  if i%6 == 0:
    print()
print()
